@extends('layouts.admin')
@section('page-title')
    {{ __('Create User') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.users') }}">{{ __('Users') }}</a></li>
    <li class="breadcrumb-item">{{ __('Create') }}</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card dashboard-user-page border">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <form method="post" class="needs-validation" novalidate
                                action="{{ route('admin.users.store') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label">{{ __('Name') }}</label><x-required></x-required>
                                        <input type="text" required placeholder="{{ __('Full name of the user') }}"
                                            name="name"
                                            class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}"
                                            value="{{ old('name') }}" autofocus>
                                        <div class="invalid-feedback">
                                            {{ $errors->first('name') }}
                                        </div>
                                    </div>
                                    <div class="form-group col-12">
                                        <label class="form-label">{{ __('Email') }}</label><x-required></x-required>
                                        <input type="email" required
                                            placeholder="{{ __('Email address (should be unique)') }}" name="email"
                                            class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}"
                                            value="{{ old('email') }}">
                                        <div class="invalid-feedback">
                                            {{ $errors->first('email') }}
                                        </div>
                                    </div>
                                    <div class="form-group col-12">
                                        <label class="form-label">{{ __('Role') }}</label><x-required></x-required>
                                        <select name="role" id="role"
                                            class="form-control  {{ $errors->has('role') ? ' is-invalid' : '' }}" required>
                                            @foreach ($roles as $key => $role)
                                                <option value="{{ $role->id }}" {{old('role') == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback">
                                            {{ $errors->first('role') }}
                                        </div>
                                    </div>
                                    <x-mobile required></x-mobile>
                                    <div class="col-12 mb-3">
                                        <span class="me-1">{{ __('Login is enabled') }}</span>
                                        <div class="form-check form-switch d-inline-block custom-switch-v1">
                                            <input type="checkbox" name="password_switch"
                                                class="form-check-input input-primary pointer"
                                                id="password_switch" {{ old('password_switch') == 'on' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="password_switch"></label>
                                        </div>
                                    </div>

                                    <div class="row ps_div d-none">
                                        <div class="form-group col-12">
                                            <label class="form-label">{{ __('Password') }}</label>
                                            <div class="col-sm-12 col-md-12">
                                                <input type="password" name="password"
                                                    placeholder="{{ __('Set an account password') }}"
                                                    class="form-control {{ $errors->has('password') ? ' is-invalid' : '' }}">
                                                <div class="invalid-feedback">
                                                    {{ $errors->first('password') }}
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group col-12">
                                            <label class="form-label">{{ __('Confirm Password') }}</label>
                                            <div class="col-sm-12 col-md-12">
                                                <input type="password" name="password_confirmation"
                                                    placeholder="{{ __('Confirm account password') }}"
                                                    class="form-control {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}">
                                                <div class="invalid-feedback">
                                                    {{ $errors->first('password_confirmation') }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group col-12">
                                        <label class="form-label">{{ __('Picture') }}</label>
                                        <span class="d-block mb-3 text-dark">Please upload a valid image file. Size of image
                                            should not be more than 2MB.</span>
                                        <div class="choose-file col-xxl-6 col-12">
                                            <label class="form-label">{{ __('Choose File Here') }}</label>
                                            <input type="file" name="avatar" id="avatar"
                                                class="form-control {{ $errors->has('avatar') ? ' is-invalid' : '' }}"
                                                data-filename="avatar_selection">
                                            <div class="invalid-feedback">
                                                {{ $errors->first('avatar') }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group col-12 d-none">
                                        <div class="user-main-image">
                                            <img src="" id="blah" width="25%" class="rounded-pill" />
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-12 col-md-12">
                                    <button class="btn btn-secondary btn-block btn-submit me-1" type="button"
                                        onclick="window.location='{{ route('admin.users') }}'"><span>{{ __('Cancel') }}</span></button>
                                        <button
                                        class="btn btn-primary btn-block btn-submit"><span>{{ __('Create') }}</span></button>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <div class="user-right-col text-center w-100 ">
                                <svg width="100%" height="560" viewBox="0 0 499 560" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M352.42 109.723L26.0957 144.078L69.8836 560L396.208 525.645L352.42 109.723Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M364.873 118.566L41.8145 167.046L98.8937 547.408L421.953 498.928L364.873 118.566Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M491.942 152.961C491.942 152.961 479.154 144.504 463.563 175.094C447.973 205.682 442.067 223.324 442.067 223.324C442.067 223.324 437.945 229.733 433.543 225.545C429.14 221.356 423.111 209.471 415.627 211.612C407.867 213.831 405.31 222.492 406.79 235.22C408.27 247.947 410.489 275.951 410.68 278.483C410.868 280.97 409.444 284.633 405.988 282.261C402.531 279.887 382.647 257.743 372.705 267.808C362.762 277.872 372.711 312.651 373.725 316.473C374.74 320.296 373.992 321.928 372.176 322.875C370.36 323.821 364.377 315.749 358.465 309.683C352.552 303.617 344.632 297.619 339.382 303.906C334.133 310.193 332.453 336.288 357.288 378.675L370.081 397.562L392.96 396.292C441.755 390.591 461.575 373.535 463.433 365.558C465.29 357.581 455.732 354.87 447.329 353.802C438.924 352.735 428.878 352.821 428.539 350.802C428.201 348.782 429.054 347.202 432.717 345.71C436.381 344.217 470.137 331.215 472.183 317.217C474.23 303.218 444.577 300.681 440.602 299.351C436.625 298.021 438.692 294.678 440.791 293.33C442.928 291.958 466.62 276.865 477.671 270.38C488.723 263.897 494.098 256.641 491.196 249.109C488.397 241.847 475.28 244.19 469.283 243.198C463.288 242.206 465.923 235.057 465.923 235.057C465.923 235.057 476.449 219.718 491.48 188.851C506.511 157.983 491.67 152.81 491.67 152.81"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M477.934 180.331C477.934 180.331 477.849 180.56 477.651 180.994C477.438 181.45 477.14 182.087 476.757 182.907C475.944 184.609 474.768 187.074 473.259 190.234C470.214 196.594 465.742 205.765 460.174 217.075C449.046 239.701 433.411 270.827 416.033 305.147C398.65 339.479 382.944 370.569 371.702 393.136C366.102 404.406 361.566 413.535 358.417 419.874C356.856 423.008 355.64 425.453 354.799 427.141C354.388 427.949 354.07 428.574 353.842 429.023C353.622 429.445 353.494 429.653 353.494 429.653C353.494 429.653 353.579 429.423 353.777 428.991C353.99 428.534 354.287 427.899 354.671 427.077C355.484 425.376 356.66 422.912 358.169 419.752C361.214 413.393 365.685 404.223 371.254 392.912C382.382 370.285 398.019 339.157 415.403 304.825C432.78 270.505 448.484 239.418 459.726 216.851C465.326 205.581 469.862 196.451 473.013 190.111C474.574 186.975 475.79 184.532 476.63 182.843C477.041 182.035 477.359 181.41 477.588 180.96C477.805 180.539 477.934 180.331 477.934 180.331Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M423.395 228.574C423.442 228.56 423.645 229.112 423.97 230.121C424.301 231.129 424.735 232.6 425.256 234.422C426.29 238.069 427.588 243.144 428.92 248.767C430.213 254.319 431.382 259.339 432.276 263.178C432.689 264.907 433.039 266.365 433.32 267.536C433.571 268.565 433.687 269.141 433.64 269.154C433.593 269.168 433.387 268.619 433.053 267.611C432.726 266.602 432.29 265.13 431.789 263.301C430.792 259.643 429.56 254.554 428.228 248.931C426.896 243.392 425.691 238.382 424.769 234.55C424.346 232.823 423.989 231.366 423.703 230.195C423.459 229.165 423.348 228.588 423.395 228.574Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M435.736 269.561C435.682 269.374 446.023 266.235 458.833 262.553C471.646 258.87 482.073 256.037 482.128 256.226C482.182 256.413 471.842 259.552 459.028 263.234C446.22 266.916 435.791 269.749 435.736 269.561Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M406.668 321.071C406.671 321.022 407.269 320.997 408.351 320.994C409.579 320.999 411.11 321.004 412.93 321.01C416.794 321.018 422.131 321.006 428.019 320.778C433.909 320.562 439.234 320.182 443.085 319.875C444.898 319.733 446.426 319.613 447.648 319.516C448.727 319.438 449.326 319.416 449.332 319.466C449.337 319.514 448.749 319.628 447.679 319.792C446.609 319.954 445.055 320.162 443.132 320.375C439.286 320.81 433.951 321.27 428.045 321.487C422.14 321.716 416.787 321.648 412.92 321.512C410.986 321.436 409.421 321.358 408.342 321.271C407.263 321.188 406.667 321.119 406.668 321.071Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M387.345 286.454C387.387 286.43 387.704 286.885 388.238 287.731C388.838 288.714 389.576 289.92 390.445 291.344C392.283 294.408 393.774 299.672 397.496 303.394C400.214 308.121 402.641 312.419 404.367 315.549C405.159 317.016 405.832 318.26 406.379 319.273C406.841 320.161 407.075 320.663 407.034 320.687C406.992 320.711 406.676 320.256 406.141 319.41C405.541 318.427 404.803 317.221 403.933 315.799C402.096 312.734 399.601 308.474 396.882 303.746C394.165 299.02 391.738 294.722 390.012 291.592C389.219 290.125 388.547 288.881 387.999 287.868C387.538 286.982 387.303 286.479 387.345 286.454Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M355.907 328.668C355.949 328.642 356.348 329.229 357.034 330.312C357.776 331.516 358.732 333.068 359.88 334.93C362.256 338.846 365.496 344.279 369.037 350.303C372.58 356.328 375.751 361.802 378.017 365.783C379.088 367.692 379.978 369.282 380.669 370.515C381.281 371.639 381.6 372.273 381.558 372.299C381.516 372.324 381.116 371.737 380.432 370.654C379.69 369.451 378.734 367.899 377.586 366.036C375.21 362.12 371.969 356.687 368.427 350.661C364.886 344.638 361.715 339.164 359.449 335.184C358.378 333.274 357.488 331.684 356.797 330.452C356.183 329.326 355.865 328.692 355.907 328.668Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M381.24 371.083C381.24 371.033 381.998 370.983 383.369 370.931C384.866 370.881 386.819 370.818 389.174 370.742C394.075 370.577 400.842 370.323 408.304 369.831C415.77 369.351 422.515 368.738 427.396 368.26C429.74 368.033 431.685 367.844 433.177 367.699C434.542 367.572 435.302 367.524 435.307 367.573C435.313 367.621 434.566 367.762 433.21 367.972C431.853 368.184 429.886 368.459 427.45 368.759C422.58 369.364 415.829 370.057 408.35 370.538C400.875 371.03 394.091 371.205 389.184 371.243C386.729 371.255 384.743 371.245 383.371 371.207C381.998 371.173 381.24 371.131 381.24 371.083Z"
                                        fill="#EBEBEB" />
                                    <path
                                        d="M2.2239 361.579C6.64549 359.132 12.1221 359.043 16.9342 360.586C21.7463 362.131 25.9574 365.177 29.5903 368.69C36.619 375.488 41.0253 385.847 43.5538 395.292C32.9049 397.421 21.8846 391.317 16.4879 387.869C7.96043 382.419 -4.14409 367.391 2.2239 361.579Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M62.065 397.535C56.9143 395.223 53.5325 389.739 53.1267 384.108C52.7209 378.477 55.0528 372.84 58.8277 368.641C60.5725 366.699 62.8892 364.933 65.4975 365.059C67.9347 365.176 70.056 367.005 71.0806 369.22C72.1052 371.435 72.1927 373.971 71.9606 376.401C71.1618 384.733 68.8603 392.649 62.065 397.535Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M79.2765 424.02C79.2372 424.052 78.7452 423.531 77.8741 422.574C76.918 421.513 75.6842 420.144 74.2006 418.499C71.1789 415.033 66.7675 410.174 63.9347 403.574C61.0855 397.02 60.3868 390.376 61.0601 385.753C61.3657 383.435 61.8932 381.606 62.3687 380.394C62.5805 379.778 62.8252 379.33 62.9622 379.018C63.1105 378.71 63.1993 378.553 63.2208 378.563C63.3819 378.614 62.0302 381.223 61.5585 385.81C61.0246 390.362 61.7867 396.849 64.5852 403.293C67.3559 409.76 71.6519 414.623 74.5785 418.172C76.0684 419.944 77.2756 421.38 78.082 422.396C78.891 423.408 79.3133 423.99 79.2765 424.02Z"
                                        fill="#263238" />
                                    <path
                                        d="M12.4529 372.21C12.4668 372.19 12.7255 372.346 13.2048 372.663C13.7412 373.027 14.4284 373.495 15.2805 374.073C17.0761 375.308 19.6501 377.126 22.8113 379.401C29.1349 383.95 37.7841 390.356 47.1738 397.644C56.5647 404.938 64.9147 411.731 70.8883 416.731C73.8758 419.23 76.2761 421.273 77.9169 422.705C78.6879 423.386 79.3105 423.938 79.7961 424.367C80.2209 424.752 80.4365 424.964 80.42 424.983C80.4048 425.002 80.1588 424.827 79.7036 424.476C79.1964 424.072 78.5446 423.556 77.7394 422.917C75.9769 421.492 73.5461 419.525 70.57 417.117C64.5178 412.219 56.1235 405.493 46.7389 398.204C37.3555 390.921 28.7596 384.456 22.5146 379.806C19.446 377.52 16.9366 375.651 15.1195 374.298C14.3004 373.675 13.6385 373.171 13.1224 372.78C12.6684 372.425 12.4376 372.229 12.4529 372.21Z"
                                        fill="#263238" />
                                    <path
                                        d="M58.1181 412.362C47.6658 406.667 34.4099 406.464 23.7877 411.837C21.083 413.205 18.2274 415.513 18.4684 418.533C18.7093 421.56 21.9148 423.39 24.8287 424.243C36.9536 427.791 51.0463 423.105 58.6329 413.002"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M31.9019 416.406C31.8804 416.363 32.47 416.039 33.5605 415.492C34.1045 415.214 34.7715 414.877 35.5855 414.575C36.3971 414.272 37.2948 413.842 38.3498 413.55C39.3947 413.227 40.5321 412.847 41.7976 412.597C43.0453 412.273 44.4072 412.073 45.8426 411.871C48.7172 411.541 51.9214 411.445 55.25 411.819C58.576 412.225 61.6751 413.049 64.3924 414.051C65.7365 414.594 67.016 415.105 68.147 415.726C69.3136 416.275 70.3255 416.923 71.255 417.499C72.2072 418.042 72.9642 418.688 73.6731 419.188C74.3844 419.686 74.9423 420.185 75.3938 420.595C76.3042 421.408 76.7899 421.874 76.7569 421.91C76.6542 422.033 74.6875 420.168 70.9912 417.926C70.0567 417.385 69.0448 416.771 67.8845 416.254C66.7598 415.664 65.4918 415.182 64.1642 414.664C61.4785 413.713 58.434 412.923 55.1663 412.523C51.8961 412.156 48.7501 412.23 45.9161 412.519C44.5023 412.701 43.1582 412.876 41.9218 413.17C40.6703 413.391 39.5392 413.739 38.4969 414.027C34.3581 415.279 31.9666 416.547 31.9019 416.406Z"
                                        fill="#263238" />
                                    <path
                                        d="M387.299 462.091C378.422 456.39 375.227 449.067 373.838 438.61C372.45 428.151 375.876 417.151 382.958 409.331C388.862 402.811 397.162 398.359 401.449 390.68C406.019 382.495 405.431 371.603 411.956 364.872C416.438 360.249 423.2 358.797 428.734 355.505C433.251 352.818 436.907 348.927 441.009 345.641C445.111 342.355 450.021 339.569 455.273 339.76C463.195 340.049 469.642 347.569 470.323 355.467C471.003 363.366 466.879 371.104 461.037 376.464C456.801 380.351 451.517 383.407 448.839 388.495C443.809 398.052 449.942 410.825 444.506 420.158C440.536 426.972 431.078 430.526 430.047 438.346C429.668 441.222 430.588 444.103 430.678 447.003C430.959 456.069 422.767 463.699 413.909 465.651C405.048 467.601 395.837 465.157 387.299 462.091Z"
                                        fill="#455A64" />
                                    <path
                                        d="M439.383 372.274C439.409 372.3 439.105 372.664 438.5 373.332C437.812 374.074 436.924 375.03 435.825 376.216C434.648 377.454 433.204 378.961 431.639 380.815C430.074 382.666 428.162 384.661 426.308 387.085C424.406 389.469 422.278 392.043 420.224 394.984C419.19 396.446 418.038 397.903 416.998 399.503C415.95 401.1 414.872 402.74 413.766 404.423C409.493 411.248 405.192 419.01 401.487 427.538C397.839 436.092 395.144 444.548 393.179 452.357C392.285 456.284 391.412 460.012 390.896 463.561C390.222 467.082 389.887 470.404 389.539 473.434C389.113 476.455 389.083 479.22 388.886 481.634C388.684 484.051 388.668 486.138 388.649 487.845C388.61 489.462 388.578 490.765 388.554 491.777C388.52 492.677 388.484 493.15 388.448 493.152C388.41 493.153 388.373 492.681 388.336 491.782C388.308 490.769 388.273 489.463 388.228 487.844C388.183 486.132 388.137 484.037 388.282 481.609C388.421 479.182 388.4 476.402 388.777 473.36C389.078 470.312 389.371 466.966 390.011 463.416C390.493 459.841 391.338 456.082 392.21 452.123C394.134 444.25 396.819 435.723 400.493 427.109C404.223 418.522 408.581 410.721 412.927 403.885C414.052 402.201 415.148 400.559 416.216 398.963C417.276 397.363 418.448 395.91 419.504 394.451C421.6 391.52 423.772 388.96 425.72 386.597C427.621 384.194 429.58 382.228 431.193 380.409C432.804 378.588 434.298 377.119 435.524 375.924C436.686 374.796 437.623 373.885 438.349 373.179C439.001 372.559 439.357 372.247 439.383 372.274Z"
                                        fill="#263238" />
                                    <path d="M395.222 141.027H68.5366V525.659H395.222V141.027Z" fill="#FAFAFA" />
                                    <path
                                        d="M395.221 525.658C395.219 523.111 395.103 370.214 394.928 141.027L395.221 141.32C298.688 141.332 187.006 141.344 68.5703 141.357H68.536L68.8657 141.027C68.8467 283.043 68.8277 415.324 68.8137 525.657L68.536 525.379C265.328 525.548 392.893 525.656 395.221 525.658C392.894 525.66 265.328 525.769 68.536 525.936H68.2583V525.658C68.2431 415.326 68.2254 283.044 68.2051 141.029V140.699H68.536H68.5703C187.007 140.713 298.688 140.726 395.221 140.736H395.514V141.029C395.339 370.216 395.224 523.114 395.221 525.658Z"
                                        fill="#263238" />
                                    <path
                                        d="M247.039 209.072H237.029L234.872 213.87H232.897L241.11 195.905H242.983L251.196 213.87H249.193L247.039 209.072ZM246.345 207.531L242.035 197.882L237.722 207.531H246.345Z"
                                        fill="#060606" />
                                    <path
                                        d="M265.976 194.827V213.87H264.231V211.202C263.127 213.025 261.253 214 259.021 214C255.171 214 252.297 211.202 252.297 207.121C252.297 203.041 255.171 200.267 259.021 200.267C261.178 200.267 263.025 201.192 264.153 202.936V194.827H265.976ZM264.177 207.121C264.177 203.964 262.022 201.859 259.173 201.859C256.299 201.859 254.143 203.964 254.143 207.121C254.143 210.279 256.299 212.382 259.173 212.382C262.022 212.382 264.177 210.277 264.177 207.121Z"
                                        fill="#060606" />
                                    <path
                                        d="M283.373 194.827V213.87H281.627V211.202C280.523 213.025 278.65 214 276.418 214C272.568 214 269.694 211.202 269.694 207.121C269.694 203.041 272.568 200.267 276.418 200.267C278.572 200.267 280.421 201.192 281.549 202.936V194.827H283.373ZM281.575 207.121C281.575 203.964 279.421 201.859 276.571 201.859C273.697 201.859 271.541 203.964 271.541 207.121C271.541 210.279 273.697 212.382 276.571 212.382C279.421 212.382 281.575 210.277 281.575 207.121Z"
                                        fill="#060606" />
                                    <path
                                        d="M307.337 200.371V213.87H305.593V211.407C304.642 213.049 302.899 214 300.742 214C297.303 214 295.047 212.075 295.047 208.199V200.371H296.868V208.017C296.868 210.891 298.357 212.356 300.924 212.356C303.746 212.356 305.517 210.532 305.517 207.453V200.371H307.337Z"
                                        fill="#060606" />
                                    <path
                                        d="M310.568 212.33L311.389 210.891C312.468 211.738 314.289 212.406 316.188 212.406C318.755 212.406 319.805 211.533 319.805 210.198C319.805 206.682 311.053 209.454 311.053 204.116C311.053 201.907 312.952 200.265 316.391 200.265C318.137 200.265 320.036 200.754 321.166 201.523L320.373 202.986C319.192 202.165 317.781 201.83 316.394 201.83C313.956 201.83 312.878 202.78 312.878 204.064C312.878 207.709 321.631 204.963 321.631 210.146C321.631 212.482 319.578 213.996 316.061 213.996C313.829 213.998 311.67 213.279 310.568 212.33Z"
                                        fill="#060606" />
                                    <path
                                        d="M336.743 207.685H325.452C325.657 210.507 327.813 212.38 330.765 212.38C332.407 212.38 333.87 211.79 334.896 210.608L335.922 211.79C334.719 213.227 332.843 213.996 330.713 213.996C326.506 213.996 323.63 211.122 323.63 207.117C323.63 203.113 326.426 200.263 330.227 200.263C334.025 200.263 336.771 203.061 336.771 207.117C336.769 207.274 336.743 207.479 336.743 207.685ZM325.452 206.326H335.026C334.794 203.681 332.869 201.834 330.227 201.834C327.608 201.834 325.683 203.681 325.452 206.326Z"
                                        fill="#060606" />
                                    <path
                                        d="M347.287 200.267V202.039C347.134 202.039 346.981 202.013 346.851 202.013C344.027 202.013 342.309 203.809 342.309 206.993V213.871H340.488V200.371H342.232V203.013C343.079 201.218 344.798 200.267 347.287 200.267Z"
                                        fill="#060606" />
                                    <path
                                        d="M226.557 318.733C226.557 318.733 226.543 318.485 226.535 318.02C226.53 317.536 226.522 316.854 226.512 315.963C226.501 314.139 226.483 311.478 226.46 308.033C226.434 301.124 226.393 291.078 226.344 278.445L226.557 278.658C196.203 278.686 150 278.728 98.375 278.776H98.3674L98.6971 278.446C98.6933 292.407 98.6907 305.971 98.6869 318.734L98.3661 318.413C135.162 318.473 167.164 318.525 189.989 318.562C201.407 318.6 210.528 318.631 216.817 318.652C219.946 318.669 222.367 318.683 224.031 318.693C224.841 318.702 225.462 318.709 225.905 318.714C226.331 318.72 226.557 318.733 226.557 318.733C226.557 318.733 226.358 318.747 225.947 318.753C225.513 318.758 224.904 318.764 224.111 318.773C222.462 318.783 220.064 318.796 216.965 318.815C210.692 318.837 201.597 318.867 190.211 318.905C167.33 318.942 135.252 318.994 98.3661 319.054H98.0453V318.733C98.0428 305.969 98.039 292.405 98.0352 278.445V278.114H98.3661H98.3737C149.999 278.161 196.201 278.204 226.555 278.232H226.77V278.445C226.72 291.133 226.68 301.221 226.653 308.16C226.63 311.586 226.612 314.23 226.601 316.043C226.591 316.918 226.583 317.588 226.578 318.063C226.571 318.515 226.557 318.733 226.557 318.733Z"
                                        fill="#263238" />
                                    <path
                                        d="M368.444 373.302C368.444 373.302 368.424 372.395 368.413 370.649C368.404 368.896 368.391 366.305 368.374 362.902C368.354 356.091 368.324 346.04 368.284 333.015L368.445 333.174C316.61 333.207 215.006 333.271 98.3825 333.344H98.3673L98.697 333.015C98.6957 346.816 98.6957 360.406 98.6944 373.302L98.3673 372.975C174.625 373.032 242.096 373.081 290.521 373.118C314.75 373.159 334.21 373.192 347.628 373.215C354.334 373.234 359.526 373.249 363.058 373.259C364.813 373.269 366.153 373.275 367.067 373.281C367.971 373.287 368.444 373.302 368.444 373.302C368.444 373.302 368 373.317 367.11 373.324C366.205 373.329 364.88 373.336 363.143 373.345C359.629 373.355 354.46 373.371 347.787 373.39C334.386 373.412 314.953 373.445 290.755 373.486C242.272 373.521 174.719 373.572 98.3673 373.629H98.0401V373.302C98.0389 360.405 98.0389 346.814 98.0376 333.015V332.685H98.3673H98.3825C215.005 332.758 316.609 332.822 368.445 332.855H368.607V333.016C368.567 346.081 368.537 356.166 368.517 362.997C368.5 366.385 368.487 368.963 368.478 370.709C368.465 372.436 368.444 373.302 368.444 373.302Z"
                                        fill="#263238" />
                                    <path
                                        d="M368.444 427.49C368.444 427.49 368.424 426.583 368.413 424.837C368.404 423.083 368.391 420.493 368.374 417.089C368.354 410.279 368.324 400.227 368.284 387.202L368.445 387.362C316.61 387.395 215.006 387.458 98.3825 387.532H98.3673L98.697 387.202C98.6957 401.003 98.6957 414.594 98.6944 427.49L98.3673 427.162C174.625 427.22 242.096 427.269 290.521 427.306C314.75 427.346 334.21 427.379 347.628 427.402C354.334 427.421 359.526 427.436 363.058 427.447C364.813 427.457 366.153 427.463 367.067 427.468C367.971 427.474 368.444 427.49 368.444 427.49C368.444 427.49 368 427.505 367.11 427.511C366.205 427.516 364.88 427.524 363.143 427.533C359.629 427.543 354.46 427.558 347.787 427.577C334.386 427.6 314.953 427.632 290.755 427.674C242.272 427.709 174.719 427.76 98.3673 427.817H98.0401V427.49C98.0389 414.593 98.0389 401.003 98.0376 387.202V386.872H98.3673H98.3825C215.005 386.946 316.609 387.009 368.445 387.042H368.607V387.203C368.567 400.269 368.537 410.354 368.517 417.184C368.5 420.573 368.487 423.15 368.478 424.897C368.465 426.624 368.444 427.49 368.444 427.49Z"
                                        fill="#263238" />
                                    <path
                                        d="M368.444 318.733C368.444 318.733 368.43 318.485 368.423 318.02C368.418 317.536 368.41 316.854 368.4 315.963C368.389 314.139 368.371 311.478 368.348 308.033C368.32 301.124 368.281 291.078 368.231 278.445L368.444 278.658C338.09 278.686 291.888 278.728 240.263 278.776H240.255L240.585 278.446C240.581 292.407 240.578 305.971 240.575 318.734L240.254 318.413C277.049 318.473 309.052 318.525 331.877 318.562C343.294 318.6 352.415 318.631 358.705 318.652C361.834 318.669 364.255 318.683 365.918 318.693C366.729 318.702 367.35 318.709 367.793 318.714C368.217 318.72 368.444 318.733 368.444 318.733C368.444 318.733 368.245 318.747 367.834 318.753C367.401 318.758 366.792 318.764 365.998 318.773C364.35 318.783 361.952 318.796 358.853 318.815C352.58 318.837 343.485 318.867 332.099 318.905C309.218 318.942 277.139 318.994 240.254 319.054H239.933V318.733C239.93 305.969 239.927 292.405 239.923 278.445V278.114H240.253H240.26C291.885 278.161 338.088 278.204 368.442 278.232H368.656L368.655 278.445C368.605 291.133 368.565 301.221 368.538 308.16C368.515 311.586 368.498 314.23 368.486 316.043C368.476 316.918 368.468 317.588 368.463 318.063C368.458 318.515 368.444 318.733 368.444 318.733Z"
                                        fill="#263238" />
                                    <path
                                        d="M125.215 304.428C125.24 304.447 124.901 304.467 124.243 304.493C123.477 304.518 122.516 304.548 121.347 304.586C118.835 304.66 115.187 304.76 110.819 304.816L110.422 304.821L110.539 304.439C110.905 303.242 111.54 302.01 112.571 301.042C113.592 300.066 114.989 299.454 116.45 299.219L116.376 299.84C114.771 299.194 113.602 297.534 113.474 295.727C113.291 293.702 114.416 291.658 116.195 290.85C117.977 289.992 120.131 290.612 121.26 291.956C122.445 293.277 122.733 295.106 122.336 296.583C121.948 298.083 120.873 299.244 119.661 299.736L119.602 299.293C120.846 299.494 121.929 299.948 122.734 300.549C123.545 301.145 124.078 301.841 124.437 302.435C125.133 303.619 125.235 304.472 125.215 304.428C125.197 304.404 125.109 304.243 124.97 303.935C124.824 303.609 124.597 303.131 124.223 302.57C123.508 301.457 121.953 300.036 119.538 299.752L118.688 299.651L119.479 299.308C120.548 298.844 121.485 297.789 121.809 296.446C122.142 295.122 121.857 293.5 120.809 292.362C119.809 291.201 117.979 290.703 116.469 291.436C114.956 292.129 113.974 293.9 114.133 295.674C114.245 297.251 115.261 298.684 116.625 299.239L117.703 299.678L116.551 299.861C115.19 300.076 113.928 300.624 112.996 301.499C112.056 302.365 111.453 303.49 111.093 304.613L110.814 304.237C115.035 304.234 118.585 304.286 121.125 304.325C122.326 304.347 123.315 304.365 124.101 304.38C124.801 304.394 125.189 304.409 125.215 304.428Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M275.491 304.428C275.517 304.447 275.178 304.467 274.52 304.493C273.754 304.518 272.793 304.548 271.624 304.586C269.112 304.66 265.464 304.76 261.097 304.816L260.7 304.821L260.816 304.439C261.183 303.242 261.818 302.01 262.849 301.042C263.871 300.066 265.267 299.454 266.728 299.219L266.654 299.84C265.049 299.194 263.881 297.534 263.753 295.727C263.57 293.702 264.694 291.658 266.474 290.85C268.256 289.992 270.41 290.612 271.539 291.956C272.724 293.277 273.012 295.106 272.615 296.583C272.227 298.083 271.152 299.244 269.94 299.736L269.881 299.293C271.125 299.494 272.208 299.948 273.013 300.549C273.824 301.145 274.358 301.841 274.716 302.435C275.41 303.619 275.511 304.472 275.491 304.428C275.473 304.404 275.386 304.243 275.246 303.935C275.101 303.609 274.874 303.131 274.5 302.57C273.784 301.457 272.23 300.036 269.814 299.752L268.965 299.651L269.756 299.308C270.825 298.844 271.762 297.789 272.085 296.446C272.419 295.122 272.133 293.5 271.086 292.362C270.086 291.201 268.256 290.703 266.746 291.436C265.233 292.129 264.249 293.9 264.41 295.674C264.522 297.251 265.537 298.684 266.902 299.239L267.979 299.678L266.828 299.861C265.466 300.076 264.205 300.624 263.273 301.499C262.333 302.365 261.729 303.49 261.369 304.613L261.09 304.237C265.312 304.234 268.862 304.286 271.402 304.325C272.603 304.347 273.592 304.365 274.378 304.38C275.078 304.394 275.466 304.409 275.491 304.428Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M140.239 295.536V298.925H144.701V299.714H140.239V303.375H139.327V294.747H145.244V295.536H140.239Z"
                                        fill="#263238" />
                                    <path
                                        d="M146.617 294.843C146.617 294.511 146.901 294.228 147.258 294.228C147.615 294.228 147.898 294.5 147.898 294.832C147.898 295.189 147.628 295.473 147.258 295.473C146.901 295.473 146.617 295.189 146.617 294.843ZM146.815 296.891H147.69V303.373H146.815V296.891Z"
                                        fill="#263238" />
                                    <path
                                        d="M153.393 296.842V297.693C153.318 297.693 153.245 297.68 153.184 297.68C151.828 297.68 151.003 298.542 151.003 300.071V303.373H150.128V296.891H150.966V298.16C151.372 297.297 152.199 296.842 153.393 296.842Z"
                                        fill="#263238" />
                                    <path
                                        d="M154.118 302.634L154.512 301.943C155.029 302.35 155.904 302.671 156.816 302.671C158.049 302.671 158.554 302.251 158.554 301.611C158.554 299.922 154.352 301.253 154.352 298.689C154.352 297.629 155.264 296.84 156.915 296.84C157.753 296.84 158.665 297.075 159.208 297.445L158.826 298.148C158.259 297.753 157.581 297.592 156.915 297.592C155.745 297.592 155.227 298.047 155.227 298.665C155.227 300.415 159.429 299.096 159.429 301.586C159.429 302.709 158.444 303.435 156.755 303.435C155.682 303.435 154.648 303.09 154.118 302.634Z"
                                        fill="#263238" />
                                    <path
                                        d="M164.453 302.979C164.108 303.287 163.59 303.435 163.085 303.435C161.865 303.435 161.187 302.744 161.187 301.55V297.63H160.028V296.891H161.187V295.474H162.062V296.891H164.034V297.63H162.062V301.5C162.062 302.264 162.456 302.685 163.183 302.685C163.54 302.685 163.898 302.573 164.144 302.351L164.453 302.979Z"
                                        fill="#263238" />
                                    <path
                                        d="M175.231 299.614V303.373H174.356V299.701C174.356 298.333 173.641 297.63 172.408 297.63C171.015 297.63 170.141 298.494 170.141 299.972V303.375H169.266V296.892H170.104V298.087C170.573 297.298 171.448 296.842 172.569 296.842C174.147 296.842 175.231 297.752 175.231 299.614Z"
                                        fill="#263238" />
                                    <path
                                        d="M182.495 299.355V303.373H181.657V302.363C181.262 303.027 180.498 303.435 179.426 303.435C177.959 303.435 177.06 302.671 177.06 301.55C177.06 300.552 177.7 299.714 179.562 299.714H181.62V299.319C181.62 298.211 180.991 297.606 179.784 297.606C178.946 297.606 178.157 297.902 177.627 298.371L177.233 297.718C177.886 297.162 178.847 296.842 179.87 296.842C181.546 296.842 182.495 297.68 182.495 299.355ZM181.62 301.426V300.365H179.586C178.328 300.365 177.921 300.86 177.921 301.524C177.921 302.276 178.526 302.744 179.561 302.744C180.547 302.744 181.275 302.276 181.62 301.426Z"
                                        fill="#263238" />
                                    <path
                                        d="M195.567 299.613V303.373H194.693V299.701C194.693 298.333 194.003 297.63 192.831 297.63C191.5 297.63 190.663 298.494 190.663 299.972V303.374H189.787V299.702C189.787 298.334 189.097 297.632 187.914 297.632C186.595 297.632 185.744 298.495 185.744 299.974V303.376H184.869V296.894H185.707V298.077C186.164 297.301 187.002 296.844 188.086 296.844C189.159 296.844 189.997 297.299 190.391 298.212C190.859 297.374 191.784 296.844 192.954 296.844C194.531 296.842 195.567 297.752 195.567 299.613Z"
                                        fill="#263238" />
                                    <path
                                        d="M203.606 300.402H198.183C198.281 301.758 199.316 302.658 200.734 302.658C201.523 302.658 202.225 302.374 202.718 301.807L203.212 302.374C202.632 303.064 201.732 303.434 200.71 303.434C198.688 303.434 197.308 302.053 197.308 300.131C197.308 298.208 198.65 296.84 200.475 296.84C202.3 296.84 203.619 298.184 203.619 300.131C203.619 300.206 203.606 300.304 203.606 300.402ZM198.183 299.75H202.779C202.669 298.481 201.744 297.593 200.475 297.593C199.219 297.592 198.294 298.481 198.183 299.75Z"
                                        fill="#263238" />
                                    <path
                                        d="M146.662 358.99V359.778H140.562V351.151H146.477V351.94H141.474V355.008H145.936V355.784H141.474V358.989L146.662 358.99Z"
                                        fill="#263238" />
                                    <path
                                        d="M159.314 356.02V359.78H158.439V356.108C158.439 354.739 157.749 354.037 156.577 354.037C155.246 354.037 154.408 354.9 154.408 356.379V359.781H153.533V356.109C153.533 354.741 152.843 354.038 151.66 354.038C150.341 354.038 149.49 354.902 149.49 356.38V359.782H148.615V353.3H149.453V354.483C149.91 353.707 150.748 353.251 151.832 353.251C152.905 353.251 153.743 353.706 154.137 354.619C154.605 353.781 155.53 353.251 156.7 353.251C158.279 353.247 159.314 354.159 159.314 356.02Z"
                                        fill="#263238" />
                                    <path
                                        d="M166.575 355.761V359.78H165.737V358.769C165.343 359.434 164.578 359.842 163.507 359.842C162.04 359.842 161.141 359.077 161.141 357.956C161.141 356.958 161.781 356.12 163.642 356.12H165.7V355.726C165.7 354.618 165.072 354.013 163.864 354.013C163.026 354.013 162.237 354.308 161.707 354.777L161.313 354.124C161.966 353.569 162.927 353.248 163.951 353.248C165.627 353.247 166.575 354.085 166.575 355.761ZM165.7 357.831V356.771H163.667C162.409 356.771 162.003 357.265 162.003 357.93C162.003 358.682 162.608 359.15 163.642 359.15C164.628 359.15 165.356 358.682 165.7 357.831Z"
                                        fill="#263238" />
                                    <path
                                        d="M168.751 351.25C168.751 350.918 169.036 350.635 169.392 350.635C169.749 350.635 170.032 350.906 170.032 351.238C170.032 351.596 169.762 351.88 169.392 351.88C169.036 351.879 168.751 351.595 168.751 351.25ZM168.949 353.296H169.824V359.778H168.949V353.296Z"
                                        fill="#263238" />
                                    <path d="M172.263 350.635H173.138V359.78H172.263V350.635Z" fill="#263238" />
                                    <path
                                        d="M143.057 408.055C143.057 409.891 141.726 410.999 139.532 410.999H137.214V413.723H136.303V405.095H139.532C141.726 405.096 143.057 406.206 143.057 408.055ZM142.144 408.055C142.144 406.674 141.233 405.885 139.507 405.885H137.214V410.197H139.507C141.233 410.197 142.144 409.409 142.144 408.055Z"
                                        fill="#263238" />
                                    <path
                                        d="M149.668 409.706V413.724H148.83V412.713C148.436 413.378 147.671 413.786 146.6 413.786C145.132 413.786 144.233 413.021 144.233 411.901C144.233 410.903 144.874 410.064 146.735 410.064H148.793V409.669C148.793 408.561 148.164 407.957 146.957 407.957C146.119 407.957 145.33 408.252 144.8 408.72L144.406 408.067C145.059 407.512 146.02 407.192 147.043 407.192C148.72 407.191 149.668 408.029 149.668 409.706ZM148.793 411.775V410.715H146.759C145.501 410.715 145.094 411.209 145.094 411.874C145.094 412.626 145.699 413.094 146.734 413.094C147.722 413.094 148.448 412.626 148.793 411.775Z"
                                        fill="#263238" />
                                    <path
                                        d="M151.143 412.984L151.537 412.292C152.054 412.699 152.929 413.02 153.841 413.02C155.073 413.02 155.579 412.601 155.579 411.96C155.579 410.271 151.376 411.603 151.376 409.039C151.376 407.979 152.288 407.19 153.939 407.19C154.777 407.19 155.688 407.425 156.231 407.795L155.849 408.497C155.283 408.102 154.604 407.942 153.939 407.942C152.768 407.942 152.251 408.397 152.251 409.015C152.251 410.764 156.453 409.446 156.453 411.936C156.453 413.058 155.468 413.785 153.779 413.785C152.707 413.785 151.673 413.44 151.143 412.984Z"
                                        fill="#263238" />
                                    <path
                                        d="M157.166 412.984L157.56 412.292C158.077 412.699 158.952 413.02 159.864 413.02C161.096 413.02 161.602 412.601 161.602 411.96C161.602 410.271 157.4 411.603 157.4 409.039C157.4 407.979 158.312 407.19 159.963 407.19C160.801 407.19 161.713 407.425 162.255 407.795L161.874 408.497C161.307 408.102 160.628 407.942 159.963 407.942C158.792 407.942 158.275 408.397 158.275 409.015C158.275 410.764 162.477 409.446 162.477 411.936C162.477 413.058 161.492 413.785 159.803 413.785C158.73 413.785 157.694 413.44 157.166 412.984Z"
                                        fill="#263238" />
                                    <path
                                        d="M173.479 407.241L171.027 413.723H170.202L168.156 408.41L166.11 413.723H165.284L162.843 407.241H163.681L165.715 412.75L167.799 407.241H168.551L170.621 412.75L172.679 407.241H173.479Z"
                                        fill="#263238" />
                                    <path
                                        d="M173.952 410.482C173.952 408.559 175.357 407.191 177.255 407.191C179.153 407.191 180.545 408.559 180.545 410.482C180.545 412.405 179.152 413.785 177.255 413.785C175.357 413.785 173.952 412.404 173.952 410.482ZM179.658 410.482C179.658 408.967 178.634 407.956 177.255 407.956C175.874 407.956 174.839 408.967 174.839 410.482C174.839 411.998 175.875 413.009 177.255 413.009C178.634 413.009 179.658 411.998 179.658 410.482Z"
                                        fill="#263238" />
                                    <path
                                        d="M185.592 407.191V408.042C185.517 408.042 185.444 408.029 185.382 408.029C184.026 408.029 183.201 408.892 183.201 410.421V413.724H182.326V407.242H183.164V408.511C183.571 407.647 184.396 407.191 185.592 407.191Z"
                                        fill="#263238" />
                                    <path
                                        d="M193.02 404.579V413.724H192.182V412.442C191.652 413.317 190.752 413.786 189.68 413.786C187.831 413.786 186.452 412.442 186.452 410.483C186.452 408.524 187.831 407.192 189.68 407.192C190.715 407.192 191.604 407.636 192.145 408.474V404.58H193.02V404.579ZM192.158 410.481C192.158 408.966 191.123 407.956 189.755 407.956C188.374 407.956 187.339 408.966 187.339 410.481C187.339 411.998 188.374 413.009 189.755 413.009C191.122 413.009 192.158 411.998 192.158 410.481Z"
                                        fill="#263238" />
                                    <path d="M285.03 295.965H285.942V303.804H290.773V304.593H285.03V295.965Z"
                                        fill="#263238" />
                                    <path
                                        d="M297.017 300.574V304.593H296.179V303.582C295.785 304.247 295.02 304.655 293.947 304.655C292.481 304.655 291.581 303.89 291.581 302.769C291.581 301.772 292.223 300.933 294.084 300.933H296.142V300.538C296.142 299.429 295.513 298.825 294.306 298.825C293.468 298.825 292.679 299.12 292.149 299.589L291.755 298.936C292.408 298.381 293.369 298.061 294.392 298.061C296.067 298.061 297.017 298.899 297.017 300.574ZM296.142 302.645V301.585H294.109C292.853 301.585 292.445 302.08 292.445 302.744C292.445 303.496 293.049 303.964 294.084 303.964C295.069 303.964 295.796 303.496 296.142 302.645Z"
                                        fill="#263238" />
                                    <path
                                        d="M298.491 303.854L298.885 303.163C299.402 303.57 300.279 303.89 301.19 303.89C302.423 303.89 302.928 303.471 302.928 302.83C302.928 301.141 298.725 302.473 298.725 299.909C298.725 298.849 299.637 298.06 301.288 298.06C302.126 298.06 303.038 298.295 303.581 298.665L303.199 299.367C302.632 298.973 301.955 298.812 301.288 298.812C300.118 298.812 299.6 299.267 299.6 299.885C299.6 301.635 303.802 300.316 303.802 302.806C303.802 303.928 302.816 304.655 301.128 304.655C300.057 304.655 299.021 304.309 298.491 303.854Z"
                                        fill="#263238" />
                                    <path
                                        d="M308.826 304.2C308.482 304.507 307.964 304.655 307.459 304.655C306.238 304.655 305.561 303.964 305.561 302.769V298.85H304.402V298.111H305.561V296.693H306.434V298.111H308.408V298.85H306.434V302.72C306.434 303.485 306.829 303.904 307.557 303.904C307.914 303.904 308.271 303.793 308.519 303.571L308.826 304.2Z"
                                        fill="#263238" />
                                    <path
                                        d="M319.604 300.833V304.593H318.729V300.919C318.729 299.551 318.015 298.849 316.781 298.849C315.389 298.849 314.514 299.712 314.514 301.191V304.593H313.639V298.111H314.477V299.305C314.945 298.517 315.821 298.06 316.942 298.06C318.519 298.061 319.604 298.972 319.604 300.833Z"
                                        fill="#263238" />
                                    <path
                                        d="M326.869 300.574V304.593H326.031V303.582C325.637 304.247 324.872 304.655 323.799 304.655C322.333 304.655 321.433 303.89 321.433 302.769C321.433 301.772 322.075 300.933 323.936 300.933H325.994V300.538C325.994 299.429 325.365 298.825 324.158 298.825C323.32 298.825 322.531 299.12 322.001 299.589L321.607 298.936C322.26 298.381 323.221 298.061 324.244 298.061C325.919 298.061 326.869 298.899 326.869 300.574ZM325.994 302.645V301.585H323.962C322.705 301.585 322.297 302.08 322.297 302.744C322.297 303.496 322.901 303.964 323.936 303.964C324.921 303.964 325.648 303.496 325.994 302.645Z"
                                        fill="#263238" />
                                    <path
                                        d="M339.941 300.833V304.593H339.066V300.919C339.066 299.551 338.376 298.849 337.205 298.849C335.873 298.849 335.035 299.712 335.035 301.191V304.593H334.161V300.919C334.161 299.551 333.47 298.849 332.287 298.849C330.968 298.849 330.118 299.712 330.118 301.191V304.593H329.243V298.111H330.081V299.294C330.536 298.518 331.376 298.061 332.46 298.061C333.532 298.061 334.371 298.517 334.764 299.429C335.233 298.591 336.157 298.061 337.328 298.061C338.905 298.061 339.941 298.972 339.941 300.833Z"
                                        fill="#263238" />
                                    <path
                                        d="M347.978 301.622H342.556C342.654 302.977 343.69 303.878 345.108 303.878C345.896 303.878 346.599 303.594 347.091 303.027L347.584 303.594C347.006 304.284 346.106 304.654 345.082 304.654C343.061 304.654 341.68 303.273 341.68 301.351C341.68 299.428 343.024 298.06 344.848 298.06C346.671 298.06 347.991 299.404 347.991 301.351C347.99 301.425 347.978 301.524 347.978 301.622ZM342.555 300.97H347.152C347.04 299.701 346.117 298.813 344.848 298.813C343.591 298.812 342.665 299.701 342.555 300.97Z"
                                        fill="#263238" />
                                    <path
                                        d="M122.817 403.86C122.786 403.828 122.752 403.514 122.705 403.033C122.667 402.578 122.679 401.838 122.242 401.1C121.84 400.369 121.002 399.654 119.909 399.512C118.834 399.341 117.551 399.833 116.879 400.907C116.605 401.341 116.432 401.829 116.399 402.32C116.384 402.85 116.37 403.364 116.355 403.864L116.043 403.547C119.836 403.607 122.701 403.778 122.817 403.86C122.931 403.944 120.15 404.115 116.044 404.172L115.729 404.177L115.732 403.856C115.739 403.345 115.726 402.856 115.751 402.269C115.786 401.677 115.99 401.077 116.324 400.551C117.14 399.245 118.724 398.668 120.002 398.911C121.309 399.119 122.254 400.017 122.657 400.883C123.094 401.768 123.012 402.577 122.95 403.113C122.889 403.647 122.846 403.892 122.817 403.86Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M120.599 412.105C120.545 412.045 120.277 411.431 119.995 410.613L119.947 410.473L120.088 410.372C120.444 410.118 120.662 409.501 120.35 409.005C120.079 408.498 119.243 408.34 118.798 408.844C118.363 409.293 118.518 410.048 118.982 410.323L119.172 410.436L119.119 410.646C118.992 411.15 118.865 411.649 118.737 412.157L118.491 411.852C119.641 411.931 120.515 412.061 120.599 412.105C120.682 412.148 119.934 412.278 118.491 412.356L118.187 412.372L118.245 412.05C118.338 411.535 118.429 411.028 118.522 410.517L118.659 410.84C117.883 410.441 117.568 409.156 118.312 408.394C118.676 407.994 119.241 407.816 119.736 407.902C120.24 407.978 120.658 408.307 120.873 408.705C121.333 409.539 120.883 410.456 120.336 410.744L120.429 410.503C120.63 411.614 120.652 412.164 120.599 412.105Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M123.745 403.871C123.773 403.868 123.937 403.827 124.306 403.923C124.66 404.016 125.2 404.262 125.631 404.853C125.845 405.144 126.014 405.526 126.077 405.967C126.127 406.421 126.107 406.85 126.124 407.347C126.14 408.342 126.155 409.452 126.174 410.667C126.18 411.284 126.188 411.928 126.195 412.597C126.166 413.28 126.294 413.929 126.114 414.755C125.914 415.536 125.313 416.238 124.506 416.554C124.12 416.719 123.626 416.759 123.25 416.748C122.853 416.751 122.452 416.752 122.045 416.754C120.416 416.761 118.709 416.767 116.943 416.773C116.5 416.775 116.054 416.775 115.604 416.776C115.131 416.795 114.583 416.685 114.135 416.432C113.213 415.952 112.635 414.837 112.723 413.824C112.725 411.866 112.728 409.958 112.73 408.118C112.731 407.659 112.733 407.204 112.734 406.754C112.729 406.331 112.72 405.791 112.91 405.326C113.255 404.384 114.134 403.715 115.068 403.59L114.811 403.884C114.83 403.277 114.817 402.729 114.863 402.104C114.925 401.494 115.112 400.912 115.39 400.399C115.948 399.369 116.869 398.634 117.845 398.282C119.85 397.545 121.822 398.395 122.758 399.518C123.765 400.645 123.912 401.927 123.86 402.677C123.81 403.408 123.767 403.85 123.745 403.871C123.724 403.893 123.692 403.502 123.666 402.69C123.655 401.934 123.453 400.774 122.489 399.765C121.589 398.764 119.789 398.064 118.023 398.755C117.162 399.086 116.359 399.752 115.884 400.665C115.645 401.118 115.491 401.628 115.444 402.162C115.412 402.682 115.427 403.308 115.416 403.894L115.411 404.152L115.158 404.188C114.434 404.294 113.759 404.819 113.501 405.545C113.359 405.909 113.368 406.281 113.374 406.754C113.376 407.204 113.377 407.659 113.378 408.118C113.381 409.958 113.383 411.867 113.386 413.824C113.32 414.696 113.757 415.467 114.458 415.858C114.812 416.051 115.18 416.136 115.607 416.123C116.057 416.124 116.504 416.124 116.946 416.125C118.713 416.132 120.418 416.138 122.049 416.144C122.858 416.11 123.695 416.255 124.298 416.011C124.932 415.772 125.421 415.224 125.589 414.606C125.743 414.017 125.654 413.247 125.688 412.595C125.696 411.927 125.702 411.283 125.71 410.665C125.727 409.452 125.744 408.342 125.758 407.346C125.759 406.866 125.793 406.383 125.767 406.003C125.729 405.614 125.598 405.267 125.419 404.995C124.656 403.89 123.669 403.946 123.745 403.871Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M129.29 361.691C129.271 361.672 129.248 361.336 129.222 360.719C129.198 360.027 129.167 359.15 129.129 358.073C129.071 355.729 128.993 352.527 128.898 348.666L129.164 348.927C123.785 348.998 117.091 349.087 109.838 349.182C109.766 349.254 110.456 348.552 110.164 348.851V348.855V348.861V348.875V348.903V348.957L110.165 349.066L110.168 349.283L110.172 349.717L110.179 350.579C110.184 351.152 110.189 351.722 110.194 352.286C110.203 353.414 110.212 354.526 110.221 355.617C110.235 357.795 110.249 359.89 110.262 361.878L109.956 361.579C115.587 361.549 120.378 361.569 123.795 361.592C125.441 361.61 126.781 361.624 127.803 361.634C128.746 361.649 129.265 361.668 129.29 361.691C129.314 361.715 128.841 361.741 127.938 361.776C126.934 361.806 125.616 361.847 123.999 361.895C120.601 361.986 115.727 362.1 109.965 362.181L109.663 362.185L109.659 361.881C109.634 359.893 109.606 357.798 109.577 355.619C109.564 354.529 109.552 353.417 109.539 352.288C109.533 351.724 109.526 351.155 109.521 350.582L109.512 349.719L109.508 349.286L109.506 349.069L109.505 348.96L109.503 348.905V348.877V348.863V348.857V348.853C109.21 349.15 109.902 348.445 109.832 348.519C117.086 348.473 123.78 348.43 129.159 348.396L129.428 348.394L129.427 348.658C129.409 352.589 129.392 355.846 129.382 358.233C129.364 359.287 129.352 360.145 129.34 360.822C129.324 361.411 129.309 361.71 129.29 361.691Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M129.162 348.663C129.215 348.737 128.189 349.582 126.487 350.891C124.786 352.2 122.408 353.97 119.758 355.892C120.099 355.89 119.29 355.9 119.371 355.897L119.367 355.895L119.36 355.89L119.345 355.878L119.313 355.857L119.251 355.812L119.125 355.725L118.875 355.551L118.382 355.206C118.056 354.978 117.735 354.752 117.418 354.529C116.795 354.086 116.188 353.657 115.603 353.241C114.501 352.442 113.479 351.701 112.55 351.028C110.823 349.752 109.782 348.927 109.834 348.852C109.886 348.777 111.023 349.468 112.818 350.645C113.77 351.283 114.82 351.984 115.951 352.741C116.545 353.147 117.157 353.565 117.789 353.998C118.107 354.217 118.43 354.44 118.757 354.666L119.252 355.01L119.502 355.183L119.627 355.271L119.689 355.314L119.721 355.335L119.738 355.347L119.745 355.352L119.749 355.355C119.834 355.356 119.028 355.361 119.37 355.357C122.02 353.435 124.441 351.724 126.213 350.513C127.985 349.301 129.108 348.59 129.162 348.663Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M110.335 361.877C110.192 361.764 111.519 359.841 113.299 357.581C115.081 355.32 116.641 353.581 116.784 353.693C116.927 353.806 115.6 355.73 113.818 357.989C112.039 360.249 110.478 361.989 110.335 361.877Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M123.077 353.693C123.222 353.582 124.728 355.281 126.444 357.49C128.16 359.699 129.433 361.579 129.288 361.692C129.145 361.804 127.637 360.105 125.922 357.896C124.207 355.686 122.934 353.805 123.077 353.693Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M365.073 489.492H101.739C99.8766 489.492 98.3677 487.982 98.3677 486.12V451.696C98.3677 449.833 99.8779 448.324 101.739 448.324H365.073C366.936 448.324 368.445 449.835 368.445 451.696V486.12C368.445 487.982 366.934 489.492 365.073 489.492Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <g opacity="0.3">
                                        <path
                                            d="M365.073 489.492H101.739C99.8766 489.492 98.3677 487.982 98.3677 486.12V451.696C98.3677 449.833 99.8779 448.324 101.739 448.324H365.073C366.936 448.324 368.445 449.835 368.445 451.696V486.12C368.445 487.982 366.934 489.492 365.073 489.492Z"
                                            fill="#060606" />
                                    </g>
                                    <path
                                        d="M365.073 483.759H101.739C99.8766 483.759 98.3677 482.249 98.3677 480.388V445.963C98.3677 444.101 99.8779 442.592 101.739 442.592H365.073C366.936 442.592 368.445 444.101 368.445 445.963V480.388C368.445 482.249 366.934 483.759 365.073 483.759Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M210.596 464.065C210.596 461.513 212.544 459.653 215.169 459.653C216.5 459.653 217.658 460.108 218.447 460.997L217.645 461.773C216.979 461.071 216.165 460.75 215.217 460.75C213.269 460.75 211.827 462.155 211.827 464.065C211.827 465.975 213.269 467.38 215.217 467.38C216.167 467.38 216.979 467.047 217.645 466.346L218.447 467.122C217.658 468.008 216.499 468.477 215.156 468.477C212.544 468.477 210.596 466.616 210.596 464.065Z"
                                        fill="white" />
                                    <path
                                        d="M225.97 468.378L224.109 465.728C223.936 465.74 223.751 465.753 223.567 465.753H221.435V468.378H220.202V459.75H223.567C225.811 459.75 227.166 460.884 227.166 462.757C227.166 464.088 226.476 465.051 225.268 465.481L227.313 468.377L225.97 468.378ZM225.934 462.757C225.934 461.524 225.108 460.823 223.529 460.823H221.435V464.705H223.529C225.108 464.706 225.934 463.991 225.934 462.757Z"
                                        fill="white" />
                                    <path
                                        d="M235.419 467.305V468.378H229.158V459.75H235.247V460.823H230.39V463.473H234.717V464.521H230.39V467.305H235.419Z"
                                        fill="white" />
                                    <path
                                        d="M242.906 466.221H238.321L237.372 468.378H236.103L240.01 459.75H241.23L245.15 468.378H243.857L242.906 466.221ZM242.475 465.236L240.613 461.008L238.752 465.236H242.475Z"
                                        fill="white" />
                                    <path
                                        d="M247.706 460.823H244.748V459.75H251.884V460.823H248.926V468.378H247.706V460.823Z"
                                        fill="white" />
                                    <path
                                        d="M259.483 467.305V468.378H253.221V459.75H259.31V460.823H254.454V463.473H258.78V464.521H254.454V467.305H259.483Z"
                                        fill="white" />
                                    <path
                                        d="M194.682 206.207C229.52 171.369 229.52 114.886 194.682 80.048C159.844 45.21 103.361 45.21 68.5226 80.048C33.6846 114.886 33.6846 171.369 68.5226 206.207C103.361 241.045 159.844 241.045 194.682 206.207Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M182.709 22.5511C179.534 26.3958 179.005 32.2198 181.436 36.5742C182.551 38.5726 184.256 40.3693 184.512 42.6442C184.93 46.3405 181.347 49.6639 181.92 53.3387C182.308 55.829 184.481 57.6132 185.628 59.8576C187.102 62.7448 186.699 66.4893 184.642 68.9962C183.017 70.9781 180.477 72.2347 179.423 74.5717C178.642 76.3038 178.831 78.3301 178.201 80.123C177.214 82.9279 174.332 84.7171 171.406 85.2433C168.479 85.7708 165.478 85.2573 162.55 84.745C162.763 83.6773 162.976 82.6084 163.189 81.5407C162.201 83.3096 160.123 84.2467 158.102 84.3937C156.08 84.5408 154.077 84.0209 152.118 83.5049C150.922 78.0651 149.738 72.3171 151.444 67.0143C152.98 62.2452 156.637 58.5261 159.68 54.5458C163.054 50.1331 165.769 45.217 167.707 40.0118C169.102 36.2648 170.11 32.3415 172.051 28.8456C173.992 25.3496 177.103 22.2265 181.032 21.4885"
                                        fill="#263238" />
                                    <path
                                        d="M240.75 97.4822L223.101 98.6817C223.101 98.6817 222.972 95.234 222.933 94.146C222.788 90.2798 223.978 88.4019 224.456 87.7298C224.704 87.3811 224.873 86.6482 224.873 86.6482C224.997 85.3028 223.014 78.5582 222.296 76.0856C221.434 73.1197 223.119 71.5486 223.773 72.7583C224.972 74.9773 228.125 84.5052 229.117 85.3764C230.108 86.2488 229.538 81.3339 229.538 81.3339C227.987 70.8499 227.317 69.3245 229.184 68.9276C231.321 68.4724 233.683 84.0805 233.683 84.0805C233.683 84.0805 233.365 81.8982 235.036 81.4544C236.706 81.0106 237.481 83.1649 237.481 83.1649C237.273 82.0529 238.858 81.8754 238.858 81.8754C242.816 82.4219 240.75 97.4822 240.75 97.4822L223.101 98.6817L214.647 157.707L205.614 143.879L182.061 160.689L203.3 186.019C207.034 190.472 212.616 192.95 218.422 192.733C228.14 192.371 235.982 184.664 236.513 174.954L240.75 97.4822Z"
                                        fill="#EB996E" />
                                    <path
                                        d="M226.908 97.6381C226.835 97.557 227.77 96.7277 229.021 95.1769C229.647 94.4021 230.343 93.441 231.008 92.3112C231.342 91.7469 231.669 91.1408 231.973 90.4954C232.259 89.8499 232.648 89.1601 232.577 88.5591C232.535 88.2053 232.336 87.9048 232.065 87.8312C231.787 87.7412 231.408 87.8439 231.059 87.9986C230.333 88.3296 229.668 88.7417 229.09 89.1779C227.932 90.0579 227.118 91.0507 226.58 91.8674L226.381 92.1691L226.227 91.8547C225.593 90.56 224.733 90.153 224.804 90.0731C224.799 90.0249 225.773 90.2963 226.587 91.6708L226.234 91.6581C226.726 90.768 227.529 89.68 228.726 88.7125C229.326 88.2307 230.012 87.7831 230.795 87.4128C231.193 87.2391 231.684 87.0451 232.257 87.2048C232.844 87.376 233.18 87.958 233.234 88.4805C233.306 89.4467 232.837 90.1188 232.558 90.7781C232.237 91.4388 231.888 92.0563 231.531 92.6282C230.817 93.7732 230.062 94.7293 229.379 95.4825C228.003 96.9863 226.953 97.6964 226.908 97.6381Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M233.896 85.0987C233.986 85.1088 233.976 86.3515 233.887 88.3461C233.829 89.4188 233.764 90.5892 233.696 91.8433C233.669 92.4874 233.564 93.2254 233.644 93.8544C233.687 94.4668 234.232 95.0006 234.681 94.7521C235.157 94.4947 235.382 93.7352 235.569 93.0669C235.761 92.3847 235.917 91.7152 236.056 91.0736C236.331 89.7903 236.535 88.6187 236.72 87.636C237.079 85.668 237.383 84.4596 237.474 84.4786C237.562 84.4964 237.422 85.7213 237.182 87.7083C237.056 88.7011 236.899 89.8842 236.653 91.194C236.529 91.8483 236.384 92.5343 236.194 93.2394C235.978 93.8987 235.872 94.794 234.976 95.343C234.507 95.6004 233.887 95.4406 233.565 95.1097C233.214 94.794 233.052 94.3362 233.005 93.9418C232.921 93.1354 233.05 92.4862 233.09 91.8141C233.21 90.555 233.322 89.382 233.423 88.3068C233.631 86.3134 233.806 85.0885 233.896 85.0987Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M236.863 89.5523C236.965 89.584 236.705 90.2916 236.787 91.429C236.844 91.959 236.946 92.7414 237.334 93.2093C237.55 93.4198 237.694 93.4274 237.907 93.1827C238.103 92.9265 238.294 92.4776 238.482 92.0922C239.996 88.8536 240.181 85.8877 240.379 85.9106C240.545 85.8852 240.658 88.983 239.082 92.3686C238.87 92.7896 238.729 93.1738 238.405 93.5973C238.245 93.7976 237.952 94.0043 237.622 93.9942C237.287 93.9916 237.027 93.7926 236.877 93.6087C236.562 93.2258 236.477 92.8048 236.405 92.4561C236.338 92.0934 236.314 91.7511 236.321 91.4417C236.36 90.1876 236.799 89.5168 236.863 89.5523Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M162.581 200.511L164.235 226.179C114.032 245.42 76.7856 213.505 76.7856 213.505L84.2961 190.541L85.6149 150.439L75.9247 161.188L71.375 157.394L48.3617 138.205L43.4253 134.089L67.3034 108.882C97.4873 76.3863 120.984 86.3592 120.984 86.3592L156.296 89.6624C156.296 89.6624 180.715 93.1203 192.531 114.527C202.151 131.956 212.629 150.408 212.629 150.408L182.372 172.001L172.756 154.318L162.581 200.511Z"
                                        fill="#FFC727" />
                                    <path
                                        d="M42.3957 142.79C42.3754 144.291 42.4338 145.795 42.4908 147.313C42.7165 153.354 43.5192 159.32 44.895 164.973C44.9089 165.028 44.9241 165.085 44.9394 165.141C45.1156 165.859 45.3223 166.565 45.5163 167.275C46.305 170.066 47.3397 172.529 48.3377 175.232C48.467 175.569 48.59 175.909 48.7231 176.244C51.9185 175.406 60.4092 167.382 70.7715 156.889L47.7759 137.714C44.7783 140.937 43.3924 142.402 42.3957 142.79Z"
                                        fill="#EB996E" />
                                    <path
                                        d="M153.088 92.9642C154.322 84.2187 155.78 75.0344 155.78 75.0344C155.78 75.0344 167.309 74.7174 171.672 60.3343C175.833 46.6168 177.989 13.9133 177.989 13.9133C162.68 5.06001 142.855 6.81495 129.497 18.203L120.65 89.396C119.623 97.661 125.911 105.126 134.769 106.158C143.716 107.2 151.914 101.295 153.088 92.9642Z"
                                        fill="#EB996E" />
                                    <path
                                        d="M170.33 38.6332C170.227 39.6337 169.297 40.373 168.249 40.2855C167.204 40.198 166.437 39.318 166.54 38.3175C166.643 37.317 167.573 36.5765 168.618 36.664C169.666 36.7515 170.432 37.6328 170.33 38.6332Z"
                                        fill="#263238" />
                                    <path
                                        d="M173.679 36.9443C173.411 37.1573 172.128 35.9032 170.098 35.6293C168.074 35.3263 166.441 36.1644 166.255 35.8855C166.162 35.7612 166.461 35.3491 167.175 34.9674C167.878 34.5857 169.03 34.2789 170.293 34.4577C171.556 34.639 172.555 35.2515 173.101 35.8119C173.659 36.3762 173.81 36.8492 173.679 36.9443Z"
                                        fill="#263238" />
                                    <path
                                        d="M149.506 36.1265C149.404 37.127 148.473 37.8663 147.426 37.7788C146.381 37.6913 145.614 36.8113 145.716 35.8108C145.819 34.8103 146.751 34.0698 147.796 34.1573C148.842 34.2448 149.609 35.1261 149.506 36.1265Z"
                                        fill="#263238" />
                                    <path
                                        d="M152.403 34.7608C152.136 34.9738 150.851 33.7198 148.822 33.4459C146.798 33.1428 145.165 33.981 144.979 33.702C144.886 33.5777 145.183 33.1656 145.899 32.7839C146.602 32.4023 147.755 32.0954 149.018 32.2742C150.28 32.4555 151.28 33.068 151.826 33.6285C152.382 34.1927 152.532 34.667 152.403 34.7608Z"
                                        fill="#263238" />
                                    <path
                                        d="M157.692 50.8264C157.698 50.7098 158.99 50.6654 161.07 50.687C161.595 50.7047 162.1 50.6692 162.237 50.3281C162.41 49.9705 162.271 49.3822 162.102 48.7443C161.788 47.4231 161.459 46.0384 161.113 44.5865C159.76 38.675 158.857 33.8426 159.094 33.7906C159.333 33.7386 160.624 38.4873 161.977 44.3988C162.297 45.8545 162.606 47.243 162.897 48.5706C163.011 49.1869 163.257 49.9008 162.886 50.6413C162.693 51.009 162.273 51.2385 161.93 51.2817C161.583 51.3375 161.292 51.3019 161.033 51.2829C158.961 51.1092 157.684 50.9431 157.692 50.8264Z"
                                        fill="#263238" />
                                    <path
                                        d="M155.781 75.0343C155.781 75.0343 145.8 74.3078 136.812 67.0648C136.812 67.0648 140.197 77.8252 155.104 78.4783L155.781 75.0343Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M162.774 9.37511C163.724 11.6956 162.23 14.4256 160.109 15.7634C157.987 17.1012 155.403 17.4106 152.925 17.7973C150.448 18.184 147.853 18.7432 145.996 20.4272C142.548 23.5516 143.424 28.0695 139.969 32.1044C138.134 34.2473 136.044 35.6523 132.662 35.1692C129.87 34.771 126.259 35.4202 124.842 38.6372C123.493 41.7033 125.135 44.2317 126.698 47.1938C128.261 50.1572 127.84 53.1738 126.955 56.4047C126.315 58.7442 124.315 60.5689 123.864 62.9515C123.153 66.7036 126.406 70.987 124.207 74.1088C122.006 77.2345 116.49 75.8092 113.997 78.7079C113.111 79.7388 112.615 81.2998 111.3 81.6497C110.514 81.859 109.695 81.5369 108.945 81.2199C105.126 79.6095 101.307 77.9991 97.4888 76.3887C97.7893 75.2057 98.0911 74.0213 98.3916 72.8383C96.7001 74.5361 94.1805 75.3667 91.8106 75.0079C89.4406 74.6477 87.2812 73.1071 86.1704 70.9831C88.4998 69.5034 90.8532 68.0033 92.7603 66.0087C94.6661 64.0141 96.1104 61.4426 96.2106 58.6846C96.3323 55.3472 94.5165 51.959 95.5335 48.7776C96.9879 44.2241 103.105 43.0778 105.854 39.1685C108.42 35.5179 107.531 30.2188 110.159 26.6126C113.212 22.4205 119.675 22.2278 123.173 18.3983C125.544 15.8027 126.088 12.0481 127.815 8.98709C129.884 5.31871 133.616 2.79408 137.617 1.47534C141.617 0.156602 145.895 -0.0627656 150.107 0.0133156C153.258 0.0703765 156.528 0.321444 159.281 1.85448C162.034 3.38879 164.119 6.54109 163.474 9.62618"
                                        fill="#263238" />
                                    <path
                                        d="M132.663 35.1679C131.132 34.6468 129.463 34.4604 127.887 34.818C126.311 35.1755 124.838 36.1075 123.989 37.4833C123.138 38.8629 122.965 40.5925 123.301 42.1775C123.637 43.7638 124.446 45.217 125.434 46.5015C126.142 47.4246 126.974 48.2919 128.027 48.7903C129.079 49.2873 130.389 49.3571 131.372 48.7345"
                                        fill="#EB996E" />
                                    <path
                                        d="M130.479 44.5805C130.652 44.6642 129.836 45.5214 128.452 44.9355C127.785 44.6578 127.194 43.9566 126.888 43.1387C126.584 42.3095 126.433 41.4257 126.465 40.4214C126.5 39.426 126.868 38.4141 127.512 37.7446C128.132 37.0586 129.037 36.7264 129.746 36.8101C131.23 36.9812 131.547 38.0692 131.374 38.0755C131.24 38.1782 130.739 37.5721 129.739 37.671C128.788 37.7142 127.7 38.8655 127.681 40.4822C127.634 42.1243 128.051 43.6916 128.861 44.1798C129.694 44.7593 130.398 44.4372 130.479 44.5805Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M162.82 10.1676C161.586 13.2997 162.957 17.2343 165.869 18.9208C167.515 19.8743 169.545 20.1723 170.954 21.4492C172.358 22.7223 172.85 24.7068 173.078 26.5885C173.306 28.4702 173.352 30.4205 174.132 32.1475C174.912 33.8745 176.697 35.3404 178.564 35.012C179.622 31.8825 180.68 28.753 181.739 25.6223C182.909 22.1618 184.092 18.4757 183.257 14.9202C182.063 9.84049 177.043 6.52082 172.013 5.13741C169.685 4.49706 167.108 4.17751 164.922 5.20334C162.736 6.23044 161.254 9.01882 162.367 11.1618"
                                        fill="#263238" />
                                    <path
                                        d="M101.612 77.9066C101.59 77.8774 101.926 77.6771 102.369 77.1179C102.799 76.5536 103.27 75.5747 103.4 74.2192C103.582 72.8649 103.274 71.2127 103.123 69.246C103.071 68.2684 103.054 67.1703 103.426 66.0798C103.749 64.9829 104.388 63.9267 105.216 62.9871C106.872 61.0926 109.2 59.6319 111.209 57.6132C112.212 56.6102 113.073 55.3954 113.494 53.9727C113.933 52.5513 113.853 50.9713 113.619 49.3901C113.381 47.8 112.975 46.1769 112.772 44.4575C112.536 42.7469 112.667 40.8931 113.287 39.1762C114.509 35.7627 117.56 32.7892 121.396 32.036C125.122 31.2105 128.952 31.7139 132.051 30.1453C133.572 29.3668 134.689 28.0455 135.381 26.5366C136.108 25.0416 136.512 23.421 136.993 21.8652C137.462 20.3055 138 18.7636 138.863 17.422C139.722 16.0767 140.997 15.0521 142.377 14.4891C145.168 13.353 147.992 13.533 150.422 13.6332C152.872 13.7587 155.1 13.779 156.959 13.2566C158.791 12.7037 160.364 11.9784 161.261 10.9779C162.172 9.97494 162.404 8.88318 162.532 8.19084C162.656 7.48329 162.657 7.09908 162.694 7.10034C162.694 7.10034 162.747 7.48329 162.664 8.20986C162.575 8.91742 162.385 10.0586 161.453 11.1479C160.52 12.2384 158.932 13.008 157.058 13.6116C155.141 14.186 152.853 14.1936 150.402 14.0985C147.97 14.0225 145.207 13.8957 142.59 14.9912C141.296 15.5352 140.145 16.4748 139.347 17.7378C138.546 19.0007 138.031 20.4881 137.573 22.0389C137.102 23.5871 136.705 25.228 135.948 26.8079C135.595 27.6068 135.088 28.3536 134.506 29.0434C133.899 29.7193 133.158 30.281 132.347 30.7172C128.981 32.4024 125.109 31.8635 121.539 32.6776C117.924 33.3851 115.061 36.176 113.893 39.3943C113.309 41.0161 113.176 42.7203 113.396 44.3839C113.585 46.0489 113.981 47.6719 114.218 49.2988C114.449 50.918 114.531 52.5956 114.047 54.1363C113.58 55.6795 112.638 56.969 111.596 57.9961C109.5 60.0617 107.178 61.4857 105.562 63.2965C103.881 65.073 103.315 67.2971 103.489 69.2245C103.599 71.1493 103.878 72.8561 103.653 74.2484C103.479 75.6394 102.949 76.6462 102.47 77.2003C101.979 77.7519 101.612 77.9066 101.612 77.9066Z"
                                        fill="#455A64" />
                                    <path
                                        d="M169.576 85.289C169.552 85.2611 169.835 85.0975 170.174 84.6169C170.516 84.1452 170.861 83.3223 170.936 82.2077C171.04 81.0944 170.747 79.7262 170.823 78.0765C170.889 76.39 171.842 74.6566 173.062 73.0437C174.234 71.4105 175.802 69.705 176.223 67.4264C176.652 65.1325 175.664 62.6979 175.186 60.0313C174.953 58.6948 174.912 57.2125 175.359 55.8151C175.782 54.419 176.534 53.1421 177.344 51.9197C178.156 50.691 179.05 49.5143 179.752 48.2133C180.459 46.9237 181.013 45.5023 181.024 44.0276C181.062 42.5478 180.395 41.1859 179.617 39.9243C178.849 38.655 177.948 37.3971 177.528 35.9211C176.656 32.9641 177.33 30.0717 177.51 27.4469C177.619 26.1244 177.647 24.831 177.428 23.6188C177.207 22.4116 176.743 21.2894 176.029 20.3828C174.609 18.5404 172.612 17.4575 170.858 16.4913C169.078 15.5478 167.414 14.6919 166.149 13.6547C164.868 12.6479 163.932 11.5548 163.386 10.5379C162.825 9.52475 162.656 8.61685 162.639 8.01581C162.614 7.41223 162.697 7.10156 162.697 7.10156C162.734 7.10283 162.704 7.41984 162.771 8.00566C162.831 8.58895 163.035 9.45374 163.609 10.4111C164.171 11.3735 165.103 12.407 166.375 13.363C167.633 14.3496 169.264 15.1535 171.076 16.0791C172.852 17.0276 174.919 18.0953 176.463 20.0493C177.237 21.0105 177.756 22.2303 177.999 23.5136C178.241 24.8031 178.218 26.1485 178.117 27.4951C177.939 30.1656 177.32 33.0098 178.146 35.7309C178.53 37.0826 179.388 38.2873 180.177 39.5832C180.968 40.8563 181.725 42.3716 181.683 44.0327C181.668 45.6747 181.062 47.19 180.328 48.5291C179.592 49.882 178.681 51.0765 177.882 52.2786C177.081 53.4794 176.36 54.703 175.961 55.999C175.544 57.2936 175.572 58.6352 175.786 59.9324C176.217 62.5026 177.239 65.0235 176.762 67.5253C176.548 68.7591 175.958 69.8255 175.346 70.76C174.723 71.6971 174.045 72.5213 173.436 73.3252C172.205 74.909 171.288 76.5219 171.192 78.1056C171.083 79.6767 171.338 81.0779 171.193 82.2318C171.076 83.3844 170.674 84.234 170.281 84.6993C169.891 85.171 169.576 85.289 169.576 85.289Z"
                                        fill="#455A64" />
                                    <path
                                        d="M88.6714 71.9597C88.679 71.9216 89.086 72.0307 89.8747 72.0599C90.6571 72.0839 91.8427 71.9825 93.221 71.4106C94.5867 70.8438 96.159 69.785 97.384 68.0643C98.6063 66.3423 99.4331 64.0016 99.6512 61.3451C99.9542 58.6772 99.2885 55.781 99.2112 52.559C99.215 50.96 99.3633 49.219 100.29 47.6644C101.224 46.1187 102.809 45.1411 104.287 44.1913C105.771 43.2466 107.294 42.1726 107.972 40.5102C108.668 38.8618 108.673 36.9268 108.783 34.9944C108.887 33.0568 109.087 31.0052 109.921 29.0981C110.358 28.1623 110.838 27.2379 111.636 26.4644C112.438 25.7074 113.502 25.2978 114.544 25.1089C116.652 24.7437 118.701 24.9643 120.656 24.7488C122.619 24.6029 124.414 23.7939 125.766 22.4676C127.13 21.1628 128.128 19.5385 128.968 17.8951C129.819 16.2505 130.477 14.5463 131.282 12.9295C132.08 11.3179 132.995 9.79118 134.136 8.48893C135.267 7.18667 136.69 6.14943 138.274 5.66631C139.861 5.18827 141.503 5.2821 142.95 5.66885C144.412 6.03404 145.715 6.63128 146.951 7.17146C149.401 8.28731 151.66 9.25481 153.785 9.33343C155.899 9.44755 157.721 9.02403 159.121 8.51809C161.941 7.45803 163.116 6.15704 163.166 6.24326C163.166 6.24326 162.897 6.57041 162.261 7.05607C161.627 7.53791 160.633 8.20235 159.213 8.75902C157.8 9.31187 155.95 9.78484 153.768 9.70242C151.559 9.65677 149.216 8.6842 146.764 7.60004C145.527 7.07508 144.233 6.50194 142.829 6.16464C141.431 5.80706 139.904 5.73986 138.436 6.19127C136.973 6.6503 135.65 7.6216 134.574 8.8744C133.49 10.1247 132.604 11.6133 131.828 13.2009C130.297 16.3507 129.105 20.1002 126.211 22.938C125.488 23.6278 124.648 24.2276 123.709 24.6524C122.771 25.086 121.74 25.2965 120.726 25.403C118.69 25.6237 116.631 25.4119 114.667 25.7594C113.694 25.9356 112.774 26.3008 112.088 26.9488C111.416 27.5878 110.929 28.4894 110.526 29.3605C109.74 31.1497 109.538 33.1088 109.431 35.0311C109.311 36.9484 109.322 38.9341 108.553 40.76C107.777 42.624 106.102 43.7653 104.618 44.7036C103.115 45.6533 101.629 46.5815 100.786 47.97C99.9479 49.3382 99.7678 51.0171 99.759 52.5577C99.8059 55.677 100.454 58.6518 100.117 61.3895C99.8629 64.1106 98.9779 66.5211 97.6845 68.2824C96.3822 70.05 94.7376 71.105 93.3174 71.6516C91.8846 72.2031 90.6622 72.264 89.8684 72.1955C89.067 72.1195 88.6714 71.9597 88.6714 71.9597Z"
                                        fill="#455A64" />
                                    <path
                                        d="M181.852 23.6328C181.718 23.6505 181.971 22.0617 180.802 19.9796C180.23 18.9551 179.326 17.8519 178.109 16.8793C176.894 15.9042 175.357 15.0851 173.7 14.3141C172.039 13.5431 170.412 12.8571 168.997 12.071C167.582 11.2899 166.391 10.4187 165.514 9.55269C164.637 8.68536 164.074 7.8472 163.771 7.23221C163.464 6.61722 163.382 6.24316 163.415 6.23048C163.524 6.16961 164.048 7.6291 165.834 9.21286C166.717 10.0028 167.891 10.8042 169.287 11.5359C170.679 12.2726 172.3 12.9358 173.98 13.7156C175.658 14.4967 177.235 15.3552 178.494 16.4076C179.751 17.455 180.666 18.6495 181.215 19.7615C181.766 20.8774 181.957 21.8855 181.971 22.574C181.989 23.2663 181.882 23.6379 181.852 23.6328Z"
                                        fill="#455A64" />
                                    <path
                                        d="M153.173 29.7179C153.042 29.8625 152.599 29.6672 151.883 29.5011C151.17 29.3185 150.155 29.179 149.021 29.1676C147.887 29.1701 146.871 29.3033 146.157 29.4795C145.439 29.6406 144.995 29.8333 144.866 29.6862C144.749 29.5645 145.038 29.0573 145.802 28.6147C146.552 28.1633 147.728 27.8476 149.026 27.8463C150.325 27.8577 151.498 28.1823 152.244 28.6401C153.005 29.0877 153.29 29.5974 153.173 29.7179Z"
                                        fill="#263238" />
                                    <path
                                        d="M171.681 32.2122C171.629 32.5736 170.302 32.6789 168.718 32.4493C167.133 32.2198 165.891 31.7405 165.943 31.3791C165.995 31.0178 167.323 30.9125 168.907 31.142C170.492 31.3728 171.735 31.8508 171.681 32.2122Z"
                                        fill="#263238" />
                                    <path
                                        d="M127.312 48.3768C127.33 48.3628 127.436 48.4719 127.624 48.6976C127.811 48.922 128.064 49.2771 128.306 49.783C128.817 50.7733 129.188 52.4471 128.868 54.4316C128.601 56.4046 127.736 58.6833 126.601 60.9822C126.092 62.1437 125.721 63.4383 126.039 64.7419C126.335 66.0517 127.131 67.2779 127.826 68.6258C128.55 69.9484 129.004 71.5359 128.772 73.0157C128.565 74.4853 127.923 75.8218 127.013 76.8261C126.116 77.8469 124.937 78.5189 123.769 78.7991C122.604 79.0832 121.508 79.0971 120.535 79.1555C118.582 79.2024 117.062 79.6449 116.184 80.2726C115.298 80.8825 115.063 81.4873 115.004 81.4455C114.988 81.4379 115.028 81.2857 115.175 81.0296C115.319 80.7734 115.587 80.4146 116.032 80.0646C116.904 79.333 118.531 78.7928 120.503 78.6888C121.482 78.6026 122.555 78.5557 123.632 78.2691C124.703 77.9863 125.746 77.3675 126.558 76.4229C127.379 75.4959 127.953 74.2622 128.131 72.9333C128.325 71.5879 127.94 70.2248 127.24 68.9263C126.573 67.6203 125.739 66.351 125.41 64.8813C125.056 63.3914 125.507 61.9167 126.045 60.7375C126.593 59.5328 127.185 58.4778 127.552 57.3988C127.95 56.3286 128.239 55.3053 128.409 54.3568C128.773 52.4547 128.493 50.8735 128.073 49.8857C127.657 48.8903 127.259 48.4161 127.312 48.3768Z"
                                        fill="#263238" />
                                    <path
                                        d="M186.192 82.4815C186.192 82.4815 185.935 82.6324 185.381 82.6337C184.837 82.6273 183.994 82.356 183.281 81.5711C182.587 80.8191 181.951 79.5194 182.241 78.0117C182.486 76.518 183.458 75.0509 184.701 73.7157C185.931 72.364 187.5 71.0833 188.506 69.2649C189.001 68.3647 189.271 67.3147 189.22 66.2255C189.182 65.1363 188.87 64.0267 188.433 62.9337C187.564 60.7362 186.144 58.5996 185.399 56.0053C185.031 54.7157 184.943 53.2663 185.352 51.8943C185.775 50.5299 186.593 49.3773 187.244 48.1879C187.905 47.0099 188.344 45.7305 188.059 44.4929C187.815 43.2553 186.975 42.2168 186.109 41.281C185.229 40.3401 184.267 39.469 183.453 38.466C182.625 37.4731 182.031 36.2901 181.731 35.0905C181.118 32.6724 181.389 30.2961 181.827 28.1976C182.28 26.0901 182.878 24.1919 183.258 22.4281C184.12 18.9131 183.748 15.9092 182.889 14.0959C182.047 12.2598 181.031 11.6157 181.104 11.5561C181.111 11.5472 181.171 11.5852 181.281 11.6689C181.39 11.7539 181.559 11.8743 181.747 12.0683C182.136 12.4399 182.662 13.0599 183.121 13.9869C183.587 14.9074 183.956 16.1374 184.094 17.5957C184.242 19.0564 184.082 20.7365 183.716 22.5257C183.358 24.3212 182.785 26.2334 182.363 28.3092C181.953 30.3684 181.724 32.6724 182.319 34.9371C182.611 36.0669 183.154 37.1333 183.94 38.0704C184.718 39.0201 185.669 39.8773 186.578 40.841C187.468 41.7996 188.404 42.9142 188.699 44.3623C189.036 45.8078 188.504 47.3016 187.819 48.5074C187.141 49.74 186.355 50.8609 185.975 52.0909C185.612 53.3196 185.678 54.6206 186.02 55.8391C186.71 58.294 188.108 60.4408 188.995 62.7118C189.44 63.8467 189.767 65.0259 189.797 66.2141C189.843 67.4009 189.527 68.5701 188.983 69.5312C187.878 71.4675 186.258 72.733 185.038 74.039C183.798 75.3286 182.859 76.7019 182.6 78.084C182.298 79.4548 182.845 80.6695 183.47 81.405C184.11 82.1645 184.874 82.4549 185.386 82.5043C185.91 82.5436 186.185 82.4422 186.192 82.4815Z"
                                        fill="#263238" />
                                    <path
                                        d="M235.955 99.61C235.776 99.6962 234.985 97.9882 233.203 96.6441C231.447 95.2657 229.593 94.9373 229.631 94.7433C229.612 94.5734 231.68 94.6216 233.606 96.1216C235.548 97.5976 236.123 99.5846 235.955 99.61Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M217.05 169.101C216.887 169.16 215.872 166.63 215.21 163.346C214.538 160.063 214.486 157.338 214.66 157.328C214.85 157.313 215.195 159.978 215.858 163.214C216.509 166.452 217.232 169.042 217.05 169.101Z"
                                        fill="#D1734A" />
                                    <path
                                        d="M136.178 154.884C140.465 153.55 143.815 149.557 144.339 144.516C145.02 137.909 140.595 132.038 134.456 131.4C128.319 130.764 122.79 135.604 122.109 142.21C121.584 147.3 124.102 151.925 128.089 154.084C118.589 154.581 113.978 160.438 111.735 165.647C115.192 170.495 120.298 174.096 126.335 175.567L133.185 176.277C139.49 176.067 145.296 173.511 149.688 169.371C148.543 163.802 145.24 157.198 136.178 154.884Z"
                                        fill="white" />
                                    <g opacity="0.3">
                                        <path
                                            d="M85.6149 150.439L91.2436 144.632C91.2436 144.632 88.8128 186.612 87.153 191.657C85.4931 196.702 76.7856 213.504 76.7856 213.504L84.2961 190.54L85.6149 150.439Z"
                                            fill="#060606" />
                                    </g>
                                    <path
                                        d="M98.0785 137.521C98.2103 137.648 93.2562 143.015 87.015 149.509C80.7725 156.005 75.6066 161.167 75.4747 161.04C75.3429 160.914 80.2957 155.547 86.5382 149.051C92.7807 142.558 97.9466 137.394 98.0785 137.521Z"
                                        fill="#263238" />
                                    <path
                                        d="M176.779 134.235C176.825 134.241 176.802 134.71 176.725 135.553C176.649 136.397 176.505 137.614 176.301 139.113C175.895 142.113 175.218 146.241 174.277 150.764C173.333 155.289 172.304 159.345 171.479 162.258C171.067 163.714 170.713 164.886 170.445 165.69C170.18 166.494 170.013 166.933 169.969 166.92C169.924 166.908 170.008 166.446 170.197 165.621C170.426 164.656 170.703 163.495 171.026 162.139C171.735 159.202 172.689 155.14 173.629 150.629C174.568 146.118 175.316 142.014 175.84 139.039C176.084 137.667 176.295 136.493 176.47 135.515C176.626 134.686 176.734 134.228 176.779 134.235Z"
                                        fill="#263238" />
                                    <path
                                        d="M151.526 51.4062C151.858 51.4328 151.559 53.6353 153.229 55.46C154.895 57.2885 157.276 57.3646 157.252 57.6753C157.264 57.8173 156.67 58.0316 155.676 57.9213C154.7 57.8211 153.323 57.3126 152.301 56.1967C151.282 55.0796 150.964 53.7317 151.015 52.8175C151.057 51.8842 151.378 51.3732 151.526 51.4062Z"
                                        fill="#263238" />
                                    <path
                                        d="M123.386 18.572C124.665 16.6624 125.989 14.6234 126.092 12.327C126.236 9.05933 123.481 5.96283 120.227 5.623C116.973 5.28317 113.685 7.65563 112.878 10.8257C112.069 13.9957 113.746 17.5906 116.646 19.1059C119.545 20.6211 123.379 19.9947 125.725 17.7148"
                                        fill="#263238" />
                                    <path
                                        d="M126.294 11.9924C126.462 11.9619 126.52 14.3128 124.987 16.6371C123.479 18.9792 121.303 19.8718 121.264 19.707C121.158 19.5371 123.041 18.4542 124.434 16.2757C125.863 14.1239 126.095 11.9632 126.294 11.9924Z"
                                        fill="#455A64" />
                                    <path
                                        d="M122.381 19.0527C122.17 19.0401 122.764 15.7686 121.553 11.9962C120.401 8.20482 118.05 5.85391 118.216 5.7233C118.269 5.66751 118.928 6.16965 119.767 7.20816C120.605 8.23906 121.57 9.84817 122.184 11.7997C122.791 13.7524 122.913 15.624 122.811 16.9491C122.714 18.2792 122.456 19.068 122.381 19.0527Z"
                                        fill="#455A64" />
                                    <path
                                        d="M167.09 251.047C184.87 251.047 199.283 236.634 199.283 218.855C199.283 201.075 184.87 186.662 167.09 186.662C149.311 186.662 134.898 201.075 134.898 218.855C134.898 236.634 149.311 251.047 167.09 251.047Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <g opacity="0.3">
                                        <path
                                            d="M167.09 251.047C184.87 251.047 199.283 236.634 199.283 218.855C199.283 201.075 184.87 186.662 167.09 186.662C149.311 186.662 134.898 201.075 134.898 218.855C134.898 236.634 149.311 251.047 167.09 251.047Z"
                                            fill="#060606" />
                                    </g>
                                    <path
                                        d="M167.09 245.072C184.87 245.072 199.283 230.659 199.283 212.88C199.283 195.1 184.87 180.687 167.09 180.687C149.311 180.687 134.898 195.1 134.898 212.88C134.898 230.659 149.311 245.072 167.09 245.072Z"
                                        fill="#6FD943" class="bg-primary" />
                                    <path
                                        d="M167.09 231.923C166.179 231.923 165.439 223.397 165.439 212.881C165.439 202.362 166.179 193.838 167.09 193.838C168.002 193.838 168.741 202.363 168.741 212.881C168.741 223.397 168.002 231.923 167.09 231.923Z"
                                        fill="white" />
                                    <path
                                        d="M186.134 212.879C186.134 213.791 177.608 214.53 167.092 214.53C156.573 214.53 148.048 213.791 148.048 212.879C148.048 211.968 156.573 211.229 167.092 211.229C177.608 211.229 186.134 211.968 186.134 212.879Z"
                                        fill="white" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            var passwordSwitch = $('#password_switch').is(':checked');
            if (passwordSwitch == true) {

                $('.ps_div').removeClass('d-none');
            } else {
                $('.ps_div').addClass('d-none');

            }
        });

        $(document).on('change', '#password_switch', function() {
            if ($(this).is(':checked')) {
                $('.ps_div').removeClass('d-none');
                $('#password').attr("required", true);

            } else {
                $('.ps_div').addClass('d-none');
                $('#password').val(null);
                $('#password').removeAttr("required");
            }
        });

        // Image Preview JS
        document.getElementById('avatar').addEventListener('change', function(event) {
            const file = event.target.files[0];

            const previewImage = document.getElementById('blah');
            const previewContainer = document.querySelector('.user-main-image');
            if (file && file.type.startsWith('image/')) {
                previewImage.src = URL.createObjectURL(file);
                previewContainer.closest('.form-group').classList.remove('d-none');
            } else {
                previewImage.src = '';
                previewContainer.closest('.form-group').classList.add('d-none');
            }

        })
    </script>
@endpush
